;Zapper 2 control program for either LCD or LED display
;Andy Flind
;23/01/03
;for PIC16F84 or PIC16F627/628 using 4MHz Xtal

;comment (;) out one of the following two config lines...
;...depending on the pic you're using.

;__config H'3FF1' ;osc = XT, wdt = OFF, put = ON (PIC16F84)
__config H'3F21' ;osc = XT, wdt = OFF, put = ON (PIC16F627/628)

#DEFINE PAGE0   BCF $03,5
#DEFINE PAGE1   BSF $03,5
#DEFINE BEEPON BCF PORTA,0
#DEFINE BEEPOFF BSF PORTA,0
#DEFINE LBTON BCF PORTA,2
#DEFINE LBTOFF BSF PORTA,2
#DEFINE OUTON BCF PORTA,1
#DEFINE OUTOFF BSF PORTA,1
#DEFINE HION BCF PORTB,7			
#DEFINE HIOFF BSF PORTB,7			
#DEFINE YON BCF PORTB,0			
#DEFINE YOFF BSF PORTB,0			
#DEFINE GON BCF PORTB,1			
#DEFINE GOFF BSF PORTB,1
			

STATUS:	.EQU $03		;general equates
PORTA:	.EQU $05		
PORTB:	.EQU $06		
TRISA:	.EQU $05		
TRISB:	.EQU $06		
PCL:	.EQU $02		
RTCC:	.EQU $01		
OPTION:	.EQU $01		
INTCON:	.EQU $0B
CMCON:	.EQU $1F		;(needed by PIC16F627/628)		
F:	.EQU $01		
W:	.EQU $00		
Z:	.EQU $02		
C:	.EQU $00		

WORD:	.EQU $20		;data word storage
RSLINE:	.EQU $21		;bit 4 RS line flag for LCD
SDELAY:	.EQU $22		;used by SEND
UT1:	.EQU $23		;used by universal timer
UT2:	.EQU $24		;used by universal timer
UT3:	.EQU $25		;used by universal timer
TCTR1:	.EQU $26		;used by timers
TCTR2:	.EQU $27		;used by timers
TCTR3:	.EQU $28		;used by timers
FLAGS:	.EQU $29		;indication bits
CTR1:	.EQU $2A		;general usage
CTR2:	.EQU $2B		;general usage

	.ORG $0004		
	.ORG $0005

	GOTO START		

WLCMT1:	ADDWF PCL,F		
	RETLW $2A		
	RETLW $2A		
	RETLW ' '		
	RETLW 'W'		
	RETLW 'e'		
	RETLW 'l'		
	RETLW 'c'		
	RETLW 'o'		
	RETLW 'm'
	RETLW 'e'
	RETLW ' '
	RETLW 'T'
	RETLW 'o'
	RETLW ' '
	RETLW $2A
	RETLW $2A

WLCMT2:	ADDWF PCL,F
	RETLW $2A
	RETLW ' '
	RETLW 'E'
	RETLW 'P'
	RETLW 'E'
	RETLW ' '
	RETLW 'Z'
	RETLW 'A'
	RETLW 'P'
	RETLW 'P'
	RETLW 'E'
	RETLW 'R'
	RETLW ' '
	RETLW '2'
	RETLW ' '
	RETLW $2A

PREPT:	ADDWF PCL,F
	RETLW ' '
	RETLW 'G'
	RETLW 'e'
	RETLW 't'
	RETLW ' '
	RETLW 'S'
	RETLW 'e'
	RETLW 't'
	RETLW ' '
	RETLW 'F'
	RETLW 'o'
	RETLW 'r'
	RETLW ' '
	RETLW '#'
	RETLW ' '
	RETLW ' '

TRTT:	ADDWF PCL,F
	RETLW ' '
	RETLW ' '
	RETLW 'T'
	RETLW 'r'
	RETLW 'e'
	RETLW 'a'
	RETLW 't'
	RETLW 'm'
	RETLW 'e'
	RETLW 'n'
	RETLW 't'
	RETLW ' '
	RETLW '#'
	RETLW ' '
	RETLW ' '
	RETLW ' '

PSET:	ADDWF PCL,F
	RETLW ' '
	RETLW 'I'
	RETLW 'n'
	RETLW 't'
	RETLW 'e'
	RETLW 'r'
	RETLW 'm
	RETLW 'i'
	RETLW 's'
	RETLW 's'
	RETLW 'i'
	RETLW 'o'
	RETLW 'n'
	RETLW ' '
	RETLW ' '
	RETLW ' '

FINT1:	ADDWF PCL,F
	RETLW 'S'
	RETLW 'e'
	RETLW 's'
	RETLW 's'
	RETLW 'i'
	RETLW 'o'
	RETLW 'n'
	RETLW ' '
	RETLW 'C'
	RETLW 'o'
	RETLW 'm'
	RETLW 'p'
	RETLW 'l'
	RETLW 'e'
	RETLW 't'
	RETLW 'e'

FINT2:	ADDWF PCL,F
	RETLW 'P'
	RETLW 'l'
	RETLW 'e'
	RETLW 'a'
	RETLW 's'
	RETLW 'e'
	RETLW ' '
	RETLW 'T'
	RETLW 'u'
	RETLW 'r'
	RETLW 'n'
	RETLW ' '
	RETLW 'O'		
	RETLW 'f'		
	RETLW 'f'		
	RETLW '!'		
;=============================================================			
START:	MOVLW 7
	MOVWF CMCON
	CLRF PORTA		
	CLRF PORTB		
	PAGE1		
	MOVLW %00011000		
	MOVWF TRISA		
	MOVLW %01000000		;RB6 input as ground passes thru it in PCB layout
	MOVWF TRISB		
	PAGE 0
	OUTOFF		;no output until called for
	LBTOFF		;no low batt until called for
	BEEPOFF		;no beep until called for
	HIOFF		;in LED program,
	YOFF		;no LEDs on
	GOFF		;until called for
	CLRF FLAGS		;all flags initially cleared
	BTFSS PORTA,3		;select LCD or LED version
	GOTO LEDPRG		;high does LCD, low does LED
;=============================================================			
;LCD program sequence			
	CALL SETUP		;initialise the LCD display and UDG's
	CALL WLCM		;display welcome message
	CALL PREP1		;prepare for treatment
	CALL TRT1		;treatment
	CALL PSE1		;pause between treatments
	CALL PREP2		
	CALL TRT2		
	CALL PSE2		
	CALL PREP3		
	CALL TRT3		
	GOTO FINALE		;last message
;=====================================================================			
;this sets up the LCD parameters and user defined graphics			
SETUP:	CALL MS100		;100mS delay
	MOVLW %00110011		;initialise lcd - first byte
	CALL SNCONT		
	MOVLW %00110011		;2nd byte (repeat of first)
	CALL SNCONT		
	MOVLW %00110010		;set for 4-bit operation
	CALL SNCONT		
	MOVLW %00101100		;set for 2 lines
	CALL SNCONT		
	MOVLW %00000110		;set entry mode to increment each address
	CALL SNCONT		
	MOVLW %00001100		;set display on, cursor off, blink off
	CALL SNCONT		
	MOVLW %00000001		;clear display
	CALL SNCONT		
	MOVLW %00000010		;return home, cursor & RAM to zero
	CALL SNCONT		
	CALL MS2		;2mS delay for LCD to execute last instruction
;this creates five user-defined graphics for the bargraph			
	MOVLW %01000000		;set CGRAM base address
	CALL SNCONT		
	MOVLW 8		
	MOVWF CTR1		
UDG1:	MOVLW %00011111		
	CALL SNDATA		
	DECFSZ CTR1,F		
	GOTO UDG1		
	MOVLW 8
	MOVWF CTR1
UDG2:	MOVLW %00011110
	CALL SNDATA
	DECFSZ CTR1,F
	GOTO UDG2
	MOVLW 8
	MOVWF CTR1
UDG3:	MOVLW %00011100
	CALL SNDATA
	DECFSZ CTR1,F
	GOTO UDG3
	MOVLW 8
	MOVWF CTR1
UDG4:	MOVLW %00011000
	CALL SNDATA
	DECFSZ CTR1,F		
	GOTO UDG4		
	MOVLW 8		
	MOVWF CTR1		
UDG5:	MOVLW %00010000		
	CALL SNDATA		
	DECFSZ CTR1,F		
	GOTO UDG5		
	MOVLW %00000010		;restore cursor home
	CALL SNCONT		
	CALL MS2		;2mS delay
	RETURN		
;=====================================================================			
;displays a welcome screen for 5 seconds			
WLCM:	CLRF CTR1		;zero counter
WLCM1:	MOVF CTR1,W		
	CALL WLCMT1		;get character
	CALL SNDATA		;send it to LCD
	INCF CTR1,F		;increment counter
	BTFSS CTR1,4		;all 16 done?
	GOTO WLCM1		;nope, so do next character
	MOVLW 168		;move to start address of 2nd line
	CALL SNCONT		
	CLRF CTR1		
WLCM2:	MOVF CTR1,W		
	CALL WLCMT2		
	CALL SNDATA		
	INCF CTR1,F		
	BTFSS CTR1,4		
	GOTO WLCM2		
	CALL MS5000		;5 seconds delay for display
	CALL WIPE		
	RETURN
;=====================================================================	
;prepare message 1, 30-second bargraph	
PREP1:	CALL PREP
	MOVLW '1'
	CALL SNDATA
	CALL BEEP
	CALL BARG30
	CALL BEEP
	CALL WIPE
	RETURN

;prepare message 2, 30-second bargraph	
PREP2:	CALL PREP
	MOVLW '2'
	CALL SNDATA
	CALL BEEP
	CALL BARG30
	CALL BEEP
	CALL WIPE
	RETURN

;prepare message 3, 30-second bargraph	
PREP3:	CALL PREP
	MOVLW '3'
	CALL SNDATA
	CALL BEEP
	CALL BARG30
	CALL BEEP
	CALL WIPE
	RETURN

;puts prep message on screen, positions cursor for number			
PREP:	CLRF CTR1		
PRPA:	MOVF CTR1,W		
	CALL PREPT		
	CALL SNDATA		
	INCF CTR1,F		
	BTFSS CTR1,4		
	GOTO PRPA		
	MOVLW %10001110		
	CALL SNCONT		;cursor to position 14
	RETURN		
;=====================================================================			
;treatment message 1, 7-minute bargraph			
TRT1:	CALL TRT		;put message on screen
	MOVLW '1'		
	CALL SNDATA		;add number
	OUTON		;turn on output
	CALL BARG7		;7 mins of bargraph
	OUTOFF		;turn off output
	CALL BEEP		;beep and flash
	CALL WIPE		
	RETURN		;done

;treatment message 2, 7-minute bargraph			
TRT2:	CALL TRT		;put message on screen
	MOVLW '2'		
	CALL SNDATA		;add number
	OUTON		;turn on output
	CALL BARG7		;7 mins of bargraph
	OUTOFF		;turn off output
	CALL BEEP		;beep and flash
	CALL WIPE		
	RETURN		;done

;treatment message 3, 7-minute bargraph			
TRT3:	CALL TRT		;put message on screen
	MOVLW '3'		
	CALL SNDATA		;add number
	OUTON		;turn on output
	CALL BARG7		;7 mins of bargraph
	OUTOFF		;turn off output
	CALL BEEP		;beep and flash
	CALL WIPE		
	RETURN		;done

;puts treatment message on screen, positions cursor for number			
TRT:	CLRF CTR1		
TRTA:	MOVF CTR1,W		
	CALL TRTT		
	CALL SNDATA		
	INCF CTR1,F		
	BTFSS CTR1,4		
	GOTO TRTA		
	MOVLW %10001101		
	CALL SNCONT		;cursor to position 13
	RETURN		
;=====================================================================			
;pause message 1, 28-minute bargraph			
PSE1:	CALL PSE		
	MOVLW '1'		
	CALL SNDATA		
	CALL BARG28		
	CALL WIPE		
	RETURN		

;pause message 2, 28-minute bargraph	
PSE2:	CALL PSE
	MOVLW '2'
	CALL SNDATA
	CALL BARG28
	CALL WIPE
	RETURN

;puts pause message on screen, positions cursor for number	
PSE:	CLRF CTR1
PSEA:	MOVF CTR1,W
	CALL PSET
	CALL SNDATA
	INCF CTR1,F
	BTFSS CTR1,4
	GOTO PSEA		
	MOVLW %10001110		
	CALL SNCONT		;cursor to position 14
	RETURN		
;=====================================================================			
;displays final message			
FINALE:	CLRF CTR1		
FIN1:	MOVF CTR1,W		
	CALL FINT1		;put final message on LCD
	CALL SNDATA		
	INCF CTR1,F		
	BTFSS CTR1,4		
	GOTO FIN1		
	MOVLW 168		;move to start address of 2nd line
	CALL SNCONT		
	CLRF CTR1		
FIN2:	MOVF CTR1,W		
	CALL FINT2		;2nd line of final message
	CALL SNDATA		
	INCF CTR1,F		
	BTFSS CTR1,4		
	GOTO FIN2		
EBEEP:	CALL MS5000		;beeps and flashes every six seconds
	CALL BEEP		;half second beep and 1 second hi-bri
	GOTO EBEEP		;keep on doing it
;=====================================================================			
;this wipes and resets the display and cursor			
WIPE:	MOVLW 1		;clear display
	CALL SNCONT		;send it
	CALL MS2		;2mS delay
	MOVLW 2		;display & cursor home
	CALL SNCONT		;send it
	CALL MS2		;2mS delay
	RETURN		;done
;=====================================================================			
;This sends the contents of W to the LCD			
SNCONT:	CLRF RSLINE		;RS line low
	CALL SEND		;send control byte to LCD
	RETURN		
SNDATA:	BSF RSLINE,4		;RS line high
	CALL SEND		;send data byte to LCD
	RETURN		
SEND:	MOVWF WORD		;temp store data
	MOVLW 25		
	MOVWF SDELAY		;brief delay for LCD to process data
SDLY:	DECFSZ SDELAY,F		
	GOTO SDLY		
	CALL SNIBL		;send MSN
	CALL SNIBL		;send LSN
	RETURN		
SNIBL:	SWAPF WORD,F		
	MOVF WORD,W		
	ANDLW 15		
	IORWF RSLINE,W		;OR the R/S bit
	BTFSC PORTB,7		;next 2 lines leave RB7 unchanged
	ADDLW 128		;for hi-bri LED drive
	MOVWF PORTB		;output to port
	BSF PORTB,5		;enable low
	BCF PORTB,5		;enable high
	RETURN		
;=====================================================================			
;half a second of beep plus 1 second of hi-bri LED			
BEEP:	BEEPON		;beeper on
	HION		;hi-bri LED on
	CALL MS500		;1/2 sec delay
	BEEPOFF		;beeper off
	CALL MS500		;1/2 sec delay
	HIOFF		;hi-bri LED off
	RETURN		
;=====================================================================			
;does bargraph over 30 seconds with flashing hi-bri on RB7			
BARG30:	HION		;turn on the hi-bri
	BSF FLAGS,1		;flag to activate hi-bri flashing
	MOVLW 17		
	MOVWF UT1		
	MOVLW 38		
	MOVWF UT2		
	MOVLW 192		
	MOVWF UT3		
	CALL BARG		
	BCF FLAGS,1		;remove hi-bri flashing activation
	RETURN		

;does bargraph over 7 minutes			
BARG7:	MOVLW 111		
	MOVWF UT1		
	MOVLW 131		
	MOVWF UT2		
	MOVLW 119		
	MOVWF UT3		
	CALL BARG		
	RETURN		

;does bargraph over 28 minutes			
BARG28:	MOVLW 238		
	MOVWF UT1		
	MOVLW 255		
	MOVWF UT2		
	MOVLW 114		
	MOVWF UT3		
	CALL BARG		
	RETURN		

;this creates a bargraph on line 2 of the display			
BARG:	MOVLW 168		;move to start address of 2nd line
	CALL SNCONT		
	MOVLW 16		;setup for 16 repeats
	MOVWF CTR1		
BAR1:	MOVLW 5		;setup for 5 repeats
	MOVWF CTR2		
BAR2:	BTFSS FLAGS,1		;is hi-bri state change required?
	GOTO BAR3		;no, so skip next three lines
	MOVF PORTB,W		;yes, fetch portB value
	ADDLW $80		;toggle MSB
	MOVWF PORTB		;return it to portB
BAR3:	DECF CTR2,W		;load loop value less 1
	CALL SNDATA		;send it's character
	CALL UTMR		;time delay, with universal timer
	CLRF RSLINE		;step back
	MOVLW %00010000		
	CALL SNCONT		
	DECFSZ CTR2,F		
	GOTO BAR2		
	MOVLW %00010100		;step forward
	CALL SNCONT		
	DECFSZ CTR1,F		;next block of 5 chars
	GOTO BAR1		
	RETURN		
;=====================================================================			
;LED program sequence	
LEDPRG:	CALL WARN1		;program sequence
	CALL TREAT		
	CALL PAUSE		
	CALL WARN2		
	CALL TREAT		
	CALL PAUSE		
	CALL WARN3		
	CALL TREAT		
	GOTO FINISH		
;=====================================================================			
WARN1:	CALL BEEP		;1S hi-bri, 0.5S beep
	MOVLW 23		;23 single flashes, on 200mS, off 1S
	MOVWF CTR1		
WRN1A:	YON		
	CALL MS200		
	YOFF		
	CALL MS1000		
	DECFSZ CTR1,F		
	GOTO WRN1A		
	RETURN		

WARN2:	CALL BEEP		
	MOVLW 17		;17 sets of 2 flashes, 200mS on, 200mS off,
	MOVWF CTR1		;200mS on, 1S off
WRN2A:	YON		
	CALL MS200		
	YOFF		
	CALL MS200		
	YON		
	CALL MS200		
	YOFF		
	CALL MS1000		
	DECFSZ CTR1,F		
	GOTO WRN2A		
	CALL MS1000		
	RETURN		

WARN3:	CALL BEEP		
	MOVLW 14		;14 sets of 2 flashes, 200mS on, 200mS off,
	MOVWF CTR1		;200mS on, 200mS off, 200mS on, 1S off
WRN3A:	YON		
	CALL MS200		
	YOFF		
	CALL MS200		
	YON		
	CALL MS200		
	YOFF
	CALL MS200
	YON
	CALL MS200
	YOFF
	CALL MS1000
	DECFSZ CTR1,F
	GOTO WRN3A 
	RETURN
;=====================================================================	
;treat for 7 minutes	
TREAT:	YON
	OUTON
	CALL BEEP
	MOVLW 7
	MOVWF CTR1
TR1:	MOVLW 60		
	MOVWF CTR2		
TR2:	CALL MS1000		
	DECFSZ CTR2,F		
	GOTO TR2		
	DECFSZ CTR1,F		
	GOTO TR1		
	OUTOFF		
	YOFF		
	CALL BEEP		;indicate end of treatment
	RETURN		
;=====================================================================			
PAUSE:	MOVLW 28		;Pause for 28 mins, 2 sec flashing
	MOVWF CTR1		
PS1:	MOVLW 30		
	MOVWF CTR2		
PS2:	GON		
	CALL MS500		
	GOFF		
	CALL MS500		
	CALL MS1000		
	DECFSZ CTR2,F		
	GOTO PS2		
	DECFSZ CTR1,F		
	GOTO PS1		
	RETURN		
;=====================================================================			
FINISH:	CALL MS5000		;Bleeps and flashes at end of program
FINSH1:	GON		
	YON		
	CALL BEEP		
	CALL MS500		
	GOFF		
	YOFF		
	CALL MS5000		
	GOTO FINSH1		
;=====================================================================			
;various timers			
MS2:	MOVLW 5		;timer, 2mS
	MOVWF TCTR1		
MS2A:	MOVLW 105		
	MOVWF TCTR2		
MS2B:	DECFSZ TCTR2,F		
	GOTO MS2B		
	DECFSZ TCTR1,F		
	GOTO MS2A		
	RETURN		

MS100:	MOVLW 198		;timer, 100mS
	MOVWF TCTR1		
MS100A:	MOVLW 167		
	MOVWF TCTR2		
MS100B:	DECFSZ TCTR2,F		
	GOTO MS100B		
	DECFSZ TCTR1,F		
	GOTO MS100A		
	RETURN		

;these timers all use UTMR			
MS200:	MOVLW 9		;200 mS
	MOVWF UT1		
	MOVLW 69		
	MOVWF UT2		
	MOVLW 106		
	MOVWF UT3		
	CALL UTMR		
	RETURN		

MS500:	MOVLW 127		;500mS
	MOVWF UT1		
	MOVLW 207		
	MOVWF UT2		
	MOVLW 5		
	MOVWF UT3		
	CALL UTMR		
	RETURN		

MS1000:	MOVLW 91		;1 second
	MOVWF UT1		
	MOVLW 65		
	MOVWF UT2		
	MOVLW 55		
	MOVWF UT3		
	CALL UTMR		
	RETURN		

MS5000:	MOVLW 105		;5 seconds
	MOVWF UT1		
	MOVLW 107		
	MOVWF UT2		
	MOVLW 147		
	MOVWF UT3		
	CALL UTMR		
	RETURN		

UTMR:	MOVF UT1,W		;timer, universal
	MOVWF TCTR1		
UTMA:	MOVF UT2,W		
	BTFSS PORTA,4		;battery check
	LBTON		
	BTFSC PORTA,4		
	LBTOFF		
	MOVWF TCTR2		
UTMB:	MOVF UT3,W		
	MOVWF TCTR3		
UTMC:	DECFSZ TCTR3,F		
	GOTO UTMC		
	DECFSZ TCTR2,F		
	GOTO UTMB		
	DECFSZ TCTR1,F		
	GOTO UTMA		
	RETURN		
;=====================================================================	
	.END
